from apm import *
import matplotlib
import numpy as np
import matplotlib.pyplot as plt
import scipy.stats

# assign s and alication names
s = 'http://byu.apmonitor.com'
#s = 'http://localhost'

a = 'ph_python'

# clear previous alication
apm(s,a,'clear all')

# load model variables and equations
apm_load(s,a,'dye.apm')

#load model variables and equations
csv_load(s,a,'dye_reduced.csv')

# Parameters to fit model
apm_info(s,a,'FV','Ea1')
apm_info(s,a,'FV','Ea2')
apm_info(s,a,'FV','A1')
apm_info(s,a,'FV','A2')
apm_info(s,a,'FV','alpha')
apm_info(s,a,'FV','beta')
apm_info(s,a,'FV','wgt')
apm_info(s,a,'MV','T')
apm_info(s,a,'MV','Ph_meas')
apm_info(s,a,'CV','PhOH')
apm_info(s,a,'CV','Ph')

# Overall options
apm_option(s,a,'nlc.imode',5)
apm_option(s,a,'nlc.solver',1)
apm_option(s,a,'Ph.fstatus',1)
apm_option(s,a,'nlc.max_iter',200)
apm_option(s,a,'nlc.ev_type',2)
apm_option(s,a,'nlc.hist_hor',0)
apm_option(s,a,'nlc.time_shift',0)

# adjust measurement gap to account for noise
apm_option(s,a,'Ph.meas_gap',0.001)

# cold start alication
apm_option(s,a,'nlc.coldstart',1)
apm(s,a,'solve')

# solve optimization problem
apm_option(s,a,'nlc.coldstart',0)
# estimate pre-exponential factors
apm_option(s,a,'A1.status',1)
apm_option(s,a,'A2.status',1)
apm(s,a,'solve')

# estimate Ea values and pre-exp values
apm_option(s,a,'Ea1.status',1)
apm_option(s,a,'Ea2.status',1)
apm(s,a,'solve')

# estimate alpha and beta
#apm_option(s,a,'alpha.status',1)
#apm_option(s,a,'beta.status',1)
#apm(s,a,'solve')

# retrieve results (also retrieves resutls in solution.csv in local folder)
(solution,result) = apm_sol(s,a)

best_obj = apm_tag(s,a,'nlc.objfcnval')

#disp(['Best obj: ' num2str(best_obj)])

# Insert optimal solution
ea1 = result['ea1'][0]
ea2 = result['ea2'][0]
a1 = result['a1'][0]
a2 = result['a2'][0]
# display values
#convertedvariable = str(ea1)
#convertedvariable = str(ea2)
#convertedvariable = str(a1)
#convertedvariable = str(a2)
#disp(['Ea1: ' ea1])
#disp(['Ea2: ' ea2])
#disp(['A1:  ' a1])
#disp(['A2:  ' a2])

# insert fixed values
apm_meas(s,a,'Ea1',ea1)
apm_meas(s,a,'Ea2',ea2)
apm_meas(s,a,'A1',a1)
apm_meas(s,a,'A2',a2)

# (S(theta) - S(theta*)) / S(theta*) <= p / (n-p) * F(p,n-p,1-alpha)
p = 4 # number of parameters
n = 60 # number of data points
alpha = 0.05 # alpha, confidence interval
finv = scipy.stats.f.isf(1-alpha,p,(n-p))
rhs = p / (n-p) * finv
ub = best_obj * rhs + best_obj

# turn off parameters
apm_option(s,a,'A1.status',0)
apm_option(s,a,'A2.status',0)
apm_option(s,a,'Ea1.status',0)
apm_option(s,a,'Ea2.status',0)

# widen lower bounds
apm_option(s,a,'A1.lower',0)
apm_option(s,a,'A2.lower',0)
apm_option(s,a,'Ea1.lower',0)
apm_option(s,a,'Ea2.lower',0)

# widen upper bounds
apm_option(s,a,'A1.upper',1e15)
apm_option(s,a,'A2.upper',1e15)
apm_option(s,a,'Ea1.upper',1e15)
apm_option(s,a,'Ea2.upper',1e15)

# find confidence interval for A1
n = 10  # number of points
A1 = np.linspace(0.8*a1,1.5*a1,n)
obj_a1 = np.zeros((n))
for i in range (n):
   apm_meas(s,a,'A1',A1[i])
   apm(s,a,'solve')
   appstatus = apm_tag(s,a,'nlc.appstatus')
   if (appstatus==1):
       obj_a1[i] = apm_tag(s,a,'nlc.objfcnval')
   else:
       obj_a1[i] = np.float('NaN')

# restore original value
apm_meas(s,a,'A1',a1)
plt.figure()
plt.plot(A1,obj_a1,'r-')
plt.plot(A1,ub*np.ones((n,1)),'k-')
#plt.legend('Objective','Upper Confidence Level')
plt.title('95% Confidence Interval for A_1')
plt.xlabel('A_1')
plt.ylabel('SSE')

# find confidence interval for Ea1
n = 10  # number of points
Ea1 = np.linspace(0.98*ea1,1.02*ea1,n)
obj_ea1 = np.zeros((n))
for i in range (n):
   apm_meas(s,a,'Ea1',Ea1[i])
   apm(s,a,'solve')
   appstatus = apm_tag(s,a,'nlc.appstatus')
   if (appstatus==1):
       obj_ea1[i] = apm_tag(s,a,'nlc.objfcnval')
   else:
       obj_ea1[i] = np.float('NaN')

# restore original value
apm_meas(s,a,'Ea1',ea1)
plt.figure()
plt.plot(Ea1,obj_ea1,'r-')

plt.plot(Ea1,ub*np.ones((n,1)),'k-')
#plt.legend('Objective','Upper Confidence Level')
plt.title('95% Confidence Interval for Ea_1')
plt.xlabel('Ea_1')
plt.ylabel('SSE')

# find confidence interval for A2
n = 10  # number of points
A2 = np.linspace(0.5*a2,2*a2,n)
obj_a2 = np.zeros((n))
for i in range (n):
   apm_meas(s,a,'A2',A2[i])
   apm(s,a,'solve')
   appstatus = apm_tag(s,a,'nlc.appstatus')
   if (appstatus==1):
       obj_a2[i] = apm_tag(s,a,'nlc.objfcnval')
   else:
       obj_a2[i] = np.float('NaN')

# restore original value
apm_meas(s,a,'A2',a2)
plt.figure()
plt.plot(A2,obj_a1,'r-')

plt.plot(A2,ub*np.ones((n,1)),'k-')
#plt.legend('Objective','Upper Confidence Level')
plt.title('95% Confidence Interval for A_2')
plt.xlabel('A_2')
plt.ylabel('SSE')

# find confidence interval for Ea2
n = 10  # number of points
Ea2 = np.linspace(0.95*ea2,1.1*ea2,n)
obj_ea2 = np.zeros((n))
for i in range (n):
   apm_meas(s,a,'Ea2',Ea2[i])
   apm(s,a,'solve')
   appstatus = apm_tag(s,a,'nlc.appstatus')
   if (appstatus==1):
       obj_ea2[i] = apm_tag(s,a,'nlc.objfcnval')
   else:
       obj_ea2[i] = np.float('NaN')

# restore original value
apm_meas(s,a,'Ea2',ea2)
plt.figure()
plt.plot(Ea2,obj_ea2,'r-')

plt.plot(Ea2,ub*np.ones((n,1)),'k-')
#plt.legend('Objective','Upper Confidence Level')
plt.title('95% Confidence Interval for Ea_2')
plt.xlabel('Ea_2')
plt.ylabel('SSE')

plt.show()

# # # compute optimal Ea values with variable A1 values
# # apm_option(s,a,'A1.status',0)
# # apm_option(s,a,'A2.status',0)
# # apm_option(s,a,'Ea2.status',0)
# # 
# # apm_option(s,a,'A1.lower',0)
# # apm_option(s,a,'A1.upper',1e15)
# # A1_banana = linspace(0.1*a1,10*a1,10)
# # 
# # # (S(theta) - S(theta*)) / S(theta*) <= p / (n-p) * F(p,n-p,1-alpha)
# # p = 4 # number of parameters
# # n = 60 # number of data points
# # alpha = 0.05 # alpha, confidence interval
# # rhs = p / (n-p) * finv(1-alpha,p,(n-p))
# # ub = best_obj * rhs + best_obj
# # 
# # for i = 1:size(A1_banana,2),
# #     # display cycle
# #     disp(['A1: ' num2str(A1_banana(i))])
# #     apm_meas(s,a,'A1',A1_banana(i))
# #     
# #     # Unconstrain
# #     apm_option(s,a,'t_obj.upper',1e10)
# #     apm_meas(s,a,'wgt',1000)
# #     apm_option(s,a,'Ea1.status',1)
# #     apm_option(s,a,'Ea1.upper',1e10)
# #     apm_option(s,a,'Ea1.lower',0)
# # 
# #     apm_option(s,a,'nlc.coldstart',1)
# #     output = apm(s,a,'solve')
# #     
# #     # Solve
# #     apm_option(s,a,'nlc.coldstart',0)
# #     output = apm(s,a,'solve')
# #     
# #     status = apm_tag(s,a,'nlc.astatus')
# #     
# #     if (status==1),
# #         obj_banana(i) = apm_tag(s,a,'nlc.objfcnval')
# #         Ea1_banana(i) = apm_tag(s,a,'ea1.newval')
# #     else
# #         obj_banana(i) = NaN
# #         Ea1_banana(i) = NaN
# #     end
# #     # check to see if this is in the confidence region
# #     #if (obj_banana(i)>ub),
# #     #    Ea1_banana(i) = NaN
# #     #    status = 0
# #     #end
# #     
# #     # get upper value on confidence interval
# #     # set the lower bound for the objective
# #     if (status==1),
# #         apm_meas(s,a,'wgt',-1000)
# #         apm_meas(s,a,'t_obj.upper',ub)
# #         apm_option(s,a,'Ea1.lower',Ea1_banana(i))
# #         apm_option(s,a,'Ea1.upper',1e10)
# #         output_hi = apm(s,a,'solve')
# #         status = (status*apm_tag(s,a,'nlc.astatus'))
# #         obj_hi(i) = apm_tag(s,a,'nlc.objfcnval')
# #     else
# #         obj_hi(i) = NaN
# #     end
# #     if (status==1),
# #         Ea1_hi(i) = apm_tag(s,a,'ea1.newval')
# #     else
# #         Ea1_hi(i) = NaN
# #     end
# #     # get lower value on confidence interval
# #     # set the lower bound for the objective
# #     if (status==1),
# #         apm_option(s,a,'Ea1.lower',-1e10)
# #         apm_option(s,a,'Ea1.upper',Ea1_banana(i))
# #         output_lo = apm(s,a,'solve')
# #         status = (status*apm_tag(s,a,'nlc.astatus'))
# #         obj_lo(i) = apm_tag(s,a,'nlc.objfcnval')
# #     else
# #         obj_lo(i) = NaN
# #     end
# #     if (status==1),
# #         Ea1_lo(i) = apm_tag(s,a,'ea1.newval')
# #     else
# #         Ea1_lo(i) = NaN
# #     end
# #     #apm_web(s,a)
# #     #stop
# # end
# # 
# # figure(1)
# # subplot(2,1,1)
# # plot(A1_banana,Ea1_banana,'b-')
# # 
# # plot(A1_banana,Ea1_hi,'r.')
# # plot(A1_banana,Ea1_lo,'g.')
# # ylabel('Activation energy (Ea1)')
# # xlabel('Pre-exponential factor (A_1)')
# # 
# # subplot(2,1,2)
# # plot(A1_banana,obj_banana,'b-')
# # 
# # plot(A1_banana,obj_hi,'r.')
# # plot(A1_banana,obj_lo,'g.')
# # ylabel('Objective Function (SSE)')
# # xlabel('Pre-exponential factor (A_1) - Log Scale')
# # 
# # # turn off all parameters
# # apm_option(s,a,'A1.status',0)
# # apm_option(s,a,'A2.status',0)
# # apm_option(s,a,'Ea1.status',0)
# # apm_option(s,a,'Ea2.status',0)
# # # eliminate variable bounds (widen to 0 to 1e15)
# # apm_option(s,a,'A1.lower',0)
# # apm_option(s,a,'A2.lower',0)
# # apm_option(s,a,'Ea1.lower',0)
# # apm_option(s,a,'Ea2.lower',0)
# # apm_option(s,a,'A1.upper',1e15)
# # apm_option(s,a,'A2.upper',1e15)
# # apm_option(s,a,'Ea1.upper',1e15)
# # apm_option(s,a,'Ea2.upper',1e15)
# #
# # range_A1 = linspace(0.1*a1,10*a1,10)
# # range_Ea1 = linspace(0.1*ea1,10*ea1,10)
# # [A1,Ea1] = meshgrid(range_A1,range_Ea1)
# #
# # apm_option(s,a,'nlc.web',0)
# #
# # for i = 1:size(A1,1),
# #     for j = 1:size(Ea1),
# #         # display cycle
# #         disp(['E1: ' num2str(Ea1(i,j)) ' A1: ' num2str(A1(i,j))])
# #
# #         apm_meas(s,a,'Ea1',Ea1(i,j))
# #         apm_meas(s,a,'A1',A1(i,j))
# #
# #         # Solve
# #         apm(s,a,'solve')
# #
# #         status = apm_tag(s,a,'nlc.astatus')
# #
# #         if (status==1),
# #             obj(i,j) = apm_tag(s,a,'nlc.objfcnval')
# #         else
# #             obj(i,j) = NaN
# #         end
# #     end
# # end
# #
# # figure(2)
# # surfc(A1,Ea1,obj)
# #
# # figure(3)
# # contour(A1,Ea1,obj)
# #

# open web viewer
#apm_web(s,a)

# # ## Traditional confidence interval method ---------------------------------
# #     # Turn up Diagnostic Level (2) for confidence intervals
# #     apm_option(s,a,'nlc.diaglevel',2)
# #     apm(s,a,'solve')
# #
# #     # retrieve objective function value
# #     obj = apm_tag(s,a,'nlc.objfcnval')
# #
# #     # # retrieve equation residuals to get number of equations
# #     apm_get(s,a,'apm_eqn.txt')
# #     load apm_eqn.txt
# #     n = size(apm_eqn,1) # get number of variables
# #
# #     # # retrieve hessian
# #     apm_get(s,a,'apm_hes_obj.txt')
# #     load apm_hes_obj.txt
# #     hs = apm_hes_obj
# #     hessian = sparse(hs(:,1),hs(:,2),hs(:,3),n,n)
# #
# #     # retrieve F matrix which is the derivative of the equations with respect
# #     # to the parameters evaluated at each point
# #     apm_get(s,a,'apm_jac_fv.txt')
# #     load apm_jac_fv.txt
# #     fs = apm_jac_fv
# #     m = max(fs(:,2))  # get number of parameters
# #     fmatrix = sparse(fs(:,1),fs(:,2),fs(:,3),n,m)
# #     # sensitivity=
# #     # alpha = confidence level
# #     # np = number of parameters
# #     # ndata = number of data points
# #     # obj = objective function value at the optimal solution
# #     # Hessian = hessian matrix at the optimal solution
# #     # bounding_box = confidence interval of parameters at optimal solution
# #     s = 1
# #     np = 6
# #     ndata = 100
# #     # # Fstat = finv(alpha,np,ndata-np)
# #     # # samplevar = obj/(ndata-np)
# #     # # a = diag(hessian)  # generally too large to compute pinv
# #     # # inva = 1./a
# #     # # bounding_box = sqrt(s*np*Fstat*samplevar*inva)
# #
# #     confidenceinterval=95% as a percentage
# #     alpha=confidenceinterval/100 +(1-confidenceinterval/100)/2
# #
# #     degoffreedom = ndata - np
# #     tstat = tinv(alpha,degoffreedom)
# #     covariancemat=(obj/(ndata-np))*pinv(full(fmatrix'*fmatrix))
# #     bounding_box=tstat*(diag(covariancemat)).^0.5# this is plus or minus for each parameter
# #     disp(['Bounding box on Ea1 : ' num2str(z.ea1(1)) ' +/- ' num2str(bounding_box(1))])
# #     disp(['Bounding box on Ea2 : ' num2str(z.ea2(1)) ' +/- ' num2str(bounding_box(2))])
# #     disp(['Bounding box on A1  : ' num2str(z.a1(1)) ' +/- ' num2str(bounding_box(3))])
# #     disp(['Bounding box on A2  : ' num2str(z.a2(1)) ' +/- ' num2str(bounding_box(4))])
# #     disp(['Bounding box on alpha  : ' num2str(z.alpha(1)) ' +/- ' num2str(bounding_box(5))])
# #     disp(['Bounding box on beta   : ' num2str(z.beta(1)) ' +/- ' num2str(bounding_box(6))])
# #     #covariancemathess=(obj/(ndata-np))*pinv(full(fmatrix'*hessian*fmatrix))
# #     #bounding_box2=tstat*(diag(covariancemathess)).^0.5
