% Steady State Estimation

% load APM libraries
addpath('apm');

% Clear MATLAB
clc
clear all
close all

% assign server and application names
server = 'http://byu.apmonitor.com';
%server = 'http://xps.apmonitor.com';

app = 'dynamicsestimate';

% clear previous application
apm(server,app,'clear all');

% load model variables and equations
apm_load(server,app,'dye.apm');

% load model variables and equations
csv_load(server,app,'dye.csv');

% Parameters to fit model
apm_info(server,app,'FV','Ea1');
apm_info(server,app,'FV','Ea2');
apm_info(server,app,'FV','A1');
apm_info(server,app,'FV','A2');
apm_info(server,app,'FV','alpha');
apm_info(server,app,'FV','gamma');
apm_info(server,app,'MV','T');
% State variables, not measured
apm_info(server,app,'SV','PhOH');
% Controlled / Measured variables
apm_info(server,app,'CV','Ph');

% Overall options
apm_option(server,app,'nlc.imode',5);
apm_option(server,app,'nlc.solver',1);
apm_option(server,app,'Ph.fstatus',1);
apm_option(server,app,'Ea1.status',1);
apm_option(server,app,'Ea2.status',1);
apm_option(server,app,'A1.status',1);
apm_option(server,app,'A2.status',1);
apm_option(server,app,'alpha.status',1);
apm_option(server,app,'gamma.status',1);
apm_option(server,app,'nlc.max_iter',200);
apm_option(server,app,'nlc.ev_type',1);

% adjust measurement gap to account for noise
apm_option(server,app,'Ph.meas_gap',0.005);

% solve
apm(server,app,'solve')

% retrieve results (also retrieves results in solution.csv in local folder)
%solution = apm_sol(server,app);

% open web viewer
apm_web(server,app);
