from apm import *
import matplotlib
import numpy as np
import matplotlib.pyplot as plt

# server
s = 'http://byu.apmonitor.com'
# application
a = 'dye_fading'

# clear previous alication
apm(s,a,'clear all')

# load model variables and equations
apm_load(s,a,'dye.apm')

# load model variables and equations
csv_load(s,a,'dye.csv')

# Parameters to fit model
apm_info(s,a,'FV','Ea1')
apm_info(s,a,'FV','Ea2')
apm_info(s,a,'FV','A1')
apm_info(s,a,'FV','A2')
apm_info(s,a,'FV','alpha')
apm_info(s,a,'FV','gamma')
apm_info(s,a,'MV','T')
# State variables, not measured
apm_info(s,a,'SV','PhOH')
# Controlled / Measured variables
apm_info(s,a,'CV','Ph')

# Overall options
apm_option(s,a,'nlc.imode',5)
apm_option(s,a,'nlc.ctrl_time',2)
apm_option(s,a,'nlc.solver',1)
apm_option(s,a,'Ph.fstatus',1)
apm_option(s,a,'Ea1.status',1)
apm_option(s,a,'Ea2.status',1)
apm_option(s,a,'A1.status',1)
apm_option(s,a,'A2.status',1)
apm_option(s,a,'alpha.status',1)
apm_option(s,a,'gamma.status',1)
apm_option(s,a,'nlc.max_iter',200)
apm_option(s,a,'nlc.ev_type',1)

# adjust measurement gap to account for noise
apm_option(s,a,'Ph.meas_gap',0.005)

# solve
apm(s,a,'solve')

# open web viewer
apm_web(s,a)

# retrieve solution
ans = apm_sol(s,a)
# plot results
plt.figure()
plt.plot(ans['time'],ans['ph'],'r-')
plt.plot(ans['time'],ans['phoh'])
plt.legend(['Ph2-','PhOH3-'])
plt.show()

