% clear everything
clc; clear all; close all

% load the apm libraries
addpath('apm')

% solve
y = apm_solve('dye');

%% Display results
% retrieve solution from structure
z = y.x;

% create a new figure
figure(1)

% top sub plot (Temperature)
subplot(2,1,1)
plot(z.time,z.t,'b-')
legend('T (Kelvin)')
ylabel('Temp (K)')

% bottom sub plot (Concentrations)
subplot(2,1,2)
plot(z.time,z.phoh,'r--')
hold on
plot(z.time,z.ph,'k.-')
legend('PhOH^{3-}','Ph^{2-}')
ylabel('Conc (mol/L)')
xlabel('Time (min)')


