from apm import *
import matplotlib
import numpy as np
import matplotlib.pyplot as plt

# server
s = 'http://byu.apmonitor.com'
# application
a = 'dyn'

# clear previous alication
apm(s,a,'clear all')

apm_web(s,a)

# load model variables and equations
apm_load(s,a,'dye.apm')

# load model variables and equations
csv_load(s,a,'data3.csv')

# Overall options
apm_option(s,a,'nlc.imode',4)
apm_option(s,a,'nlc.ctrl_time',2)
apm_option(s,a,'nlc.solver',1)
apm_option(s,a,'ph[0].fstatus',1)
apm_option(s,a,'ph[1].fstatus',1)
apm_option(s,a,'ph[2].fstatus',1)
apm_option(s,a,'Ea1.status',1)
apm_option(s,a,'Ea2.status',1)
apm_option(s,a,'A1.status',1)
apm_option(s,a,'A2.status',1)
apm_option(s,a,'alpha.status',1)
apm_option(s,a,'gamma.status',1)
apm_option(s,a,'nlc.max_iter',200)
apm_option(s,a,'nlc.ev_type',1)

# adjust measurement gap to account for noise
apm_option(s,a,'ph.meas_gap',0.005)

# Parameters to fit model
apm_info(s,a,'FV','Ea1')
apm_info(s,a,'FV','Ea2')
apm_info(s,a,'FV','A1')
apm_info(s,a,'FV','A2')
apm_info(s,a,'FV','alpha')
apm_info(s,a,'FV','gamma')
apm_info(s,a,'MV','T[0]')
apm_info(s,a,'MV','T[1]')
apm_info(s,a,'MV','T[2]')
# State variables, not measured
apm_info(s,a,'SV','phOH[0]')
apm_info(s,a,'SV','phOH[1]')
apm_info(s,a,'SV','phOH[2]')
# Controlled / Measured variables
apm_info(s,a,'CV','ph[0]')
apm_info(s,a,'CV','ph[1]')
apm_info(s,a,'CV','ph[2]')

# solve
output = apm(s,a,'solve')
print(output)
solution = apm_sol(s,a)

# open web viewer
apm_web(s,a)

# retrieve solution
ans = apm_sol(s,a)

# plot results
##plt.figure()
##plt.plot(ans['time'],ans['ph[1]'],'r-')
##plt.plot(ans['time'],ans['phoh[1]'])
##plt.legend(['Ph2-','PhOH3-'])
##plt.show()
