clear all; close all; clc

addpath('apm')

% Select server
server = 'http://xps.apmonitor.com';

% Application name
app = 'ethyl_acetate';
model_file = 'EtAc.apm';
data_file = 'data.csv';

% Clear previous application
apm(server,app,'clear all');

% Load model file
apm_load(server,app,model_file);

% Load data file
csv_load(server,app,data_file);

% Option to select solver (1=APOPT, 2=BPOPT, 3=IPOPT)
apm_option(server,app,'nlc.solver',1);
apm_option(server,app,'nlc.max_iter',400);

% Classify parameters and variables
apm_info(server,app,'FV','A');
apm_info(server,app,'FV','Ea');
apm_info(server,app,'FV','alpha');
apm_info(server,app,'FV','beta');
apm_info(server,app,'MV','Tk');
apm_info(server,app,'MV','c_OH');
apm_info(server,app,'CV','c_EtAc');

% Options
apm_option(server,app,'nlc.csv_read',1);
apm_option(server,app,'nlc.ev_type',1);
apm_option(server,app,'nlc.imode',5);

% Initialize Data reconciliation
apm_option(server,app,'nlc.coldstart',1);
apm(server,app,'solve')

apm_option(server,app,'A.status',1);
apm_option(server,app,'Ea.status',1);

% Estimate reaction orders
estimate_orders = false;
if estimate_orders,
  apm_option(server,app,'alpha.status',1);
  apm_option(server,app,'beta.status',1);
else
  apm_option(server,app,'alpha.status',0);
  apm_option(server,app,'beta.status',0);
end

apm_option(server,app,'c_EtAc.fstatus',1);
apm_option(server,app,'c_EtAc.wmeas',100);

% Turn up Diagnostic Level for bounding box generation
apm_option(server,app,'nlc.diaglevel',0);

% Solve Data reconciliation
apm(server,app,'solve')

% Display Results in Web Viewer 
url = apm_web(server,app);

% Retrieve data
y = apm_sol(server,app);
z = y.x;

% Retrieve measurements from data file
data = csv_data(data_file);
[nrow,ncol] = size(data);
% retrieve time
icol = csv_lookup('time',data);
for i = 2:nrow,
   time_meas(i-1) = str2num(data{i,icol});
end
% retrieve EtAc concentration
icol = csv_lookup('c_EtAc',data);
for i = 2:nrow,
   c_EtAc_meas(i-1) = str2num(data{i,icol});
end

figure(1)

subplot(2,1,1)
plot(z.time/60,z.c_etac,'k-')
hold on
plot(time_meas/60,c_EtAc_meas,'r.')
legend('EtAc_{model}','EtAc_{meas}')
ylabel('c_{EtAc}')

subplot(2,1,2)
plot(z.time/60,z.tk-273.15,'b-')
ylabel('T (degC)')
xlabel('Time (min)')


% % %% --------------------------------------------------------------
% % % retrieve objective function value
% % obj = apm_tag(server,app,'nlc.objfcnval');
% % 
% % % % retrieve equation residuals to get number of equations
% % apm_get(server,app,'apm_eqn.txt');
% % load apm_eqn.txt
% % n = size(apm_eqn,1); % get number of variables
% % 
% % % % retrieve hessian
% % apm_get(server,app,'apm_hes_obj.txt');
% % load apm_hes_obj.txt
% % hs = apm_hes_obj;
% % hessian = sparse(hs(:,1),hs(:,2),hs(:,3),n,n);
% % 
% % % retrieve F matrix which is the derivative of the equations with respect
% % % to the parameters evaluated at each point
% % apm_get(server,app,'apm_jac_fv.txt');
% % load apm_jac_fv.txt
% % fs = apm_jac_fv;
% % m = max(fs(:,2));  % get number of parameters
% % fmatrix = sparse(fs(:,1),fs(:,2),fs(:,3),n,m);
% % % sensitivity=
% % % alpha = confidence level (e.g. 95%)
% % % np = number of parameters
% % % ndata = number of data points
% % % obj = objective function value at the optimal solution
% % % Hessian = hessian matrix at the optimal solution
% % % bounding_box = confidence interval of parameters at optimal solution
% % s = 1;
% % np = 2;
% % ndata = 100;
% % % % Fstat = finv(alpha,np,ndata-np);
% % % % samplevar = obj/(ndata-np);
% % % % a = diag(hessian);  % generally too large to compute pinv
% % % % inva = 1./a;
% % % % bounding_box = sqrt(s*np*Fstat*samplevar*inva);
% % 
% % confidenceinterval=95;% as a percentage
% % alpha=confidenceinterval/100 +(1-confidenceinterval/100)/2;
% % 
% % degoffreedom = ndata - np;
% % tstat = tinv(alpha,degoffreedom);
% % covariancemat=(obj/(ndata-np))*pinv(full(fmatrix'*fmatrix));
% % bounding_box=tstat*(diag(covariancemat)).^0.5;% this is plus or minus for each parameter
% % disp(['Bounding box on A : ' num2str(z.a(1)) ' +/- ' num2str(bounding_box(2))]);
% % disp(['Bounding box on Ea: ' num2str(z.ea(1)) ' +/- ' num2str(bounding_box(4))]);
% % %covariancemathess=(obj/(ndata-np))*pinv(full(fmatrix'*hessian*fmatrix));
% % %bounding_box2=tstat*(diag(covariancemathess)).^0.5;
