% clear everything
clear all; close all; clc

%% solve with APM MATLAB
% load the libraries
addpath('apm')

% select the server
server = 'http://byu.apmonitor.com';

% give the application a name
app = 'twobar';

% clear any previous applications by that name
apm(server,app,'clear all');

% load the model file
apm_load(server,app,'twobar.apm');

% solve the optimization problem
apm(server,app,'solve');

% retrieve the solution
y = apm_sol(server,app);
z = y.x;

% display the solution
disp(['Height:   ' num2str(z.height)])
disp(['Diameter: ' num2str(z.diameter)])
disp(['Weight:   ' num2str(z.weight)])

%% generate contour plot

% constants
pi = 3.14159;
dens = 0.3;
modu = 30000;
load = 66.0;

% analysis variables
wdth = 60;
thik = 0.15;

% design variables at mesh points
[hght,diam] = meshgrid(10:2:30,1:.3:3);

% equations
leng = ((wdth/2)^2 + hght.^2).^0.5;
area = pi * diam .* thik;
iovera = (diam.^2 + thik^2)/8;
wght = 2 * dens * leng .* area;
strs = load * leng ./ (2 * area .* hght);
buck = pi^2 * modu * iovera ./ (leng.^2);
defl = load * leng.^3 ./ (2*modu * area .* hght.^2);

figure(1)
contour(hght,diam,wght,12:3:33,'k');
title('Two Bar Truss Contour Plot');
xlabel('Height');
ylabel('Diameter');
hold on;
% solid lines to show constraint boundaries
contour(hght,diam,strs,[100,100],'g-','LineWidth',3);
contour(hght,diam,defl,[0.25,0.25],'r-','LineWidth',3);
contour(hght,diam,(strs-buck),[0.0,0.0],'b-','LineWidth',3);
% show a legend
legend('Weight','Stress<100','Deflection<0.25','Stress-Buckling<0')

figure(2)
[C,h] = contour(hght,diam,wght,12:3:33,'k.');
clabel(C,h,'Labelspacing',250);
title('Two Bar Truss Contour Plot');
xlabel('Height');
ylabel('Diameter');
hold on;
[C,h] = contour(hght,diam,strs,[85,90,95,100],'g.-');
clabel(C,h,'Labelspacing',250);
[C,h] = contour(hght,diam,defl,[0.19,0.21,0.23,0.25],'r:');
clabel(C,h,'Labelspacing',250);
[C,h] = contour(hght,diam,(strs-buck),[-30.0,-20.0,-10.0,0.0],'b--');
clabel(C,h,'Labelspacing',250);
% show a legend
legend('Weight','Stress<100','Deflection<0.25','Stress-Buckling<0')
% solid lines to show constraint boundaries
contour(hght,diam,strs,[100,100],'g-','LineWidth',3);
contour(hght,diam,defl,[0.25,0.25],'r-','LineWidth',3);
contour(hght,diam,(strs-buck),[0.0,0.0],'b-','LineWidth',3);

figure(3)
surfc(hght,diam,wght);
