# Import APM Python library apm.py
from apm import *

# Select the server
server = 'http://byu.apmonitor.com'

# Give the application a name
app = 'twobar'

# Clear any previous applications by that name
apm(server,app,'clear all')

# Load the model file
apm_load(server,app,'twobar.apm')

# Solve on APM server
solver_output = apm(server,app,'solve')

# Display solver output
print(solver_output)

# Retrieve results
sol = apm_sol(server,app)

print ('')
print ('--- Results of the Optimization Problem ---')
print ('Height: ' + str(sol['height']))
print ('Diameter: ' + str(sol['diameter']))
print ('Weight: ' + str(sol['weight']))

print ('')
print ('--- All available variables ---')
print (sol.keys())

# Display Results in Web Viewer 
url = apm_web_var(server,app)

## Generate a contour plot
# Import some other libraries that we'll need
# matplotlib and numpy packages must also be installed
import matplotlib
import numpy as np
import matplotlib.pyplot as plt

# Constants
pi = 3.14159
dens = 0.3
modu = 30000.0
load = 66.0

# Analysis variables
wdth = 60.0
thik = 0.15

# Design variables at mesh points
x = np.arange(10.0, 30.0, 2.0)
y = np.arange(1.0, 3.0, 0.3)
hght, diam = np.meshgrid(x, y)

# Equations and Constraints
leng = ((wdth/2.0)**2.0 + hght**2)**0.5
area = pi * diam * thik
iovera = (diam**2.0 + thik**2.0)/8.0
wght = 2.0 * dens * leng * area
strs = load * leng / (2.0 * area * hght)
buck = pi**2.0 * modu * iovera / (leng**2.0)
defl = load * leng**3.0 / (2.0*modu * area * hght**2.0)

# Create a contour plot
# Visit http://matplotlib.org/examples/pylab_examples/contour_demo.html
#   for more examples and options for contour plots
plt.figure()
# Weight contours
CS = plt.contour(hght, diam, wght)
plt.clabel(CS, inline=1, fontsize=10)
# Stress<100
CS = plt.contour(hght, diam, strs,[100.0],colors='k',linewidths=[4.0])
plt.clabel(CS, inline=1, fontsize=10)
# Deflection<0.25
CS = plt.contour(hght, diam, defl,[0.25],colors='b',linewidths=[4.0])
plt.clabel(CS, inline=1, fontsize=10)
# Stress-Buckling<0
CS = plt.contour(hght, diam, strs-buck,[0.0],colors='r',linewidths=[4.0])
plt.clabel(CS, inline=1, fontsize=10)
# Add some labels
plt.title('Two Bar Optimization Problem')
plt.xlabel('Height')
plt.ylabel('Diameter')
# Save the figure as a PNG
plt.savefig('contour1.png')

# Create a new figure to see more detail
plt.figure()
# Weight contours
CS = plt.contour(hght, diam, wght)
plt.clabel(CS, inline=1, fontsize=10)
# Stress<100
CS = plt.contour(hght, diam, strs,[90.0,100.0],colors='k',linewidths=[0.5, 4.0])
plt.clabel(CS, inline=1, fontsize=10)
# Deflection<0.25
CS = plt.contour(hght, diam, defl,[0.22,0.25],colors='b',linewidths=[0.5, 4.0])
plt.clabel(CS, inline=1, fontsize=10)
# Stress-Buckling<0
CS = plt.contour(hght, diam, strs-buck,[-5.0,0.0],colors='r',linewidths=[0.5, 4.0])
plt.clabel(CS, inline=1, fontsize=10)
# Add some labels
plt.title('Two Bar Optimization Problem')
plt.xlabel('Height')
plt.ylabel('Diameter')
# Save the figure as a PNG
plt.savefig('contour2.png')

# Show the plots
plt.show()

# For a 3-D plot use something like:
#   http://matplotlib.org/examples/mplot3d/surface3d_demo.html
