% clear everything
clear all; close all; clc

%% solve with APM MATLAB
% load the libraries
addpath('apm')

% select the server
server = 'http://byu.apmonitor.com';

% give the application a name
app = ['twobar_' int2str(rand()*1000)];

% optimize at mesh points
[width,load] = meshgrid(40:5:80,45:5:85);

% get size of mesh matrices
[rows,cols] = size(width);
total = rows * cols;

% clear any previous applications by that name
apm(server,app,'clear all');

% load the model file
apm_load(server,app,'twobar.apm');

% input parameters that change each cycle
apm_info(server,app,'FV','width');
apm_info(server,app,'FV','load');

k = 0;
for i = 1:rows,
    for j = 1:cols,
        % print a message each cycle (optional)
        k = k + 1;
        disp([' -- Cycle ' int2str(k) ' of ' int2str(total) ' -- '...
            ' Width ' num2str(width(i,j)) ...
            ' Load ' num2str(load(i,j))])

        % Change width and load values
        apm_meas(server,app,'width',width(i,j));
        apm_meas(server,app,'load',load(i,j));
                
        % % Another option for changing width and load
        % %  is to use a data file (CSV format)
        % fid = fopen('data.csv','w');
        % line1 = ['width,' num2str(width(i,j)) '\n'];
        % line2 = ['load,' num2str(load(i,j))];
        % fprintf(fid,line1);
        % fprintf(fid,line2);
        % fclose(fid);
        %
        % % clear csv file
        % apm(server,app,'clear csv');
        %
        % % load csv to server
        % csv_load(server,app,'data.csv');
        
        % solve the optimization problem
        apm(server,app,'solve');
        
        % check if the solution is good
        status = apm_tag(server,app,'nlc.appstatus');
        
        % record values if successful solution
        if (status==1),
            % retrieve the solution
            y = apm_sol(server,app);
            z = y.x;
            
            weight(i,j) = z.weight;
            
            % optimal design variables (not plotted)
            height(i,j) = z.height;
            diameter(i,j) = z.diameter;
        else
            % some combinations may fail or be infeasible
            % record "NaN" for failed runs
            weight(i,j) = nan;

            % optimal design variables (not plotted)
            height(i,j) = nan;
            diameter(i,j) = nan;
        end
    end
end

% plot the results
figure(1)
surfc(width,load,weight);
title('Two Bar Truss Optimal Values');
xlabel('Width (in)');
ylabel('Load (klbs)');
zlabel('Weight (lbs)');
