## solve with APM Python
# load the libraries
from apm import *
from random import randint
import numpy as np

# select the server
server = 'http://byu.apmonitor.com'

# give the application a name
app = 'twobar_' + str(randint(2,999))

# optimize at mesh points
x = np.arange(40.0, 85.0, 5.0)
y = np.arange(45.0, 90.0, 5.0)
width, load = np.meshgrid(x, y)

# initialize weight array
weight = np.empty_like(width)

# clear any previous applications by that name
apm(server,app,'clear all')

# load the model file
apm_load(server,app,'twobar.apm')

# input parameters that change each cycle
apm_info(server,app,'FV','width')
apm_info(server,app,'FV','load')

k = 0
for i in range(0,width.shape[0]):
    for j in range(0,load.shape[1]):
        # print a message each cycle (optional)
        k = k + 1
        print ' -- Cycle ' + str(k) + ' -- ' + \
            ' Width ' + str(width[i,j]) + \
            ' Load ' + str(load[i,j])

        # Change width and load values
        apm_meas(server,app,'width',width[i,j])
        apm_meas(server,app,'load',load[i,j])
        
        # solve the optimization problem
        apm(server,app,'solve')
        
        # check if the solution is good
        status = apm_tag(server,app,'nlc.appstatus')
            
        # record values if successful solution
        if (status==1):
            # retrieve the solution
            # Retrieve results
            (results, array) = apm_sol(server,app)

            print '   Weight: ', array['weight'][0]
            weight[i,j] = array['weight'][0]
        else:
            print '   Infeasible solution'
            # some combinations may fail or be infeasible
            # record "NaN" for failed runs
            weight[i,j] = float('NaN')

from mpl_toolkits.mplot3d import Axes3D
import matplotlib.pyplot as plt
from matplotlib import cm
import numpy as np

fig = plt.figure()
ax = fig.gca(projection='3d')
surf = ax.plot_surface(width, load, weight, \
                       rstride=1, cstride=1, cmap=cm.coolwarm, \
                       vmin = 7, vmax = 24, linewidth=0, antialiased=False)
plt.show()

