# import packages
import numpy as np
import matplotlib.pyplot as plt
from apm import *

# solve integration problem
z = apm_solve('myModel',7)

# plot results
plt.figure(1)

# plot t (time that starts at 2.0)
plt.subplot(211)
plt.plot(z['time'],z['t'],'k-',label='Time (starts at 2.0)')
plt.legend(loc=1)

# plot x and y (implicit solution / explicit solution)
plt.subplot(212)
plt.plot(z['time'],z['x'],'r-',label='Implicit Integration')
plt.plot(z['time'],z['y'],'b--',label='Explicit Integration')
plt.ylabel('Functions')
plt.xlabel('Simulation Time (starts at 0.0)')
plt.legend(loc=1)

# save figure and display on screen
plt.savefig('myPlot.png')
plt.show()
