clear all; close all; clc

addpath('apm')
%s = 'http://byu.apmonitor.com';
a = 'shuttle_op9';
% apm_info(s,a,'MV','br');
% apm_option(s,a,'br.status',1);
% apm_option(s,a,'nlc.sensitivity',1);

y = apm_solve(a,6)
z = y.x;
t_day = z.time/(24*3600);
x_moon = 384400 - 6371 - 1738;
mass_limit = 1028000;
%g_limit = 9;
figure(1)
subplot(5,1,1)
plot(t_day,z.v,'r-')
ylabel('Velocity(m/s)')
xlabel('Time (days)')

subplot(5,1,2)
plot(t_day,z.x/1000,'b--')
hold on
plot(t_day,x_moon * ones(size(t_day)),'g-','LineWidth',3)
ylabel('Distance (km)')
legend('Shuttle Position','Moon Surface')
xlabel('Time (days)')

subplot(5,1,3)
plot(t_day,z.br,'k-.','MarkerSize',5,'LineWidth',2)
ylabel('Burn Rate (kg/s)')
xlabel('Time (days)')

subplot(5,1,4)
plot(t_day,z.m1,'b-')
hold on
plot(t_day,mass_limit * ones(size(t_day)),'g-','LineWidth',3)
ylabel('mass spaceship(kg)')
legend('Mass of Spaceship','Mass Limit')
xlabel('Time (days)')

subplot(5,1,5)
%plot(t_day,z.gf,'b-')
%hold on
%plot(t_day,g_limit * ones(size(t_day)),'g-','LineWidth',3)
plot(t_day,z.intb,'r-')
%ylabel('g force','g limit','F1 R0')
xlabel('Time (days)')
ylabel('intb value')



% obj = apm_tag(s,a,'nlc.objfcnval');
% disp(['Objective: ' num2str(obj)]);
% 
% apm_web(s,a);


