import numpy as np
import matplotlib.pyplot as plt
from APMonitor.apm import *

def y(x):
   return 1.0/(1.0+25.0*np.power(x,2))

s = 'http://byu.apmonitor.com'
a = 'cspline'

apm(s,a,'clear all')
apm_load(s,a,'cspline_plot.apm')
csv_load(s,a,'cspline_plot.csv')

apm_option(s,a,'apm.imode',2)
apm_option(s,a,'apm.diaglevel',0)
apm_option(s,a,'apm.max_iter',50)
apm_option(s,a,'apm.solver',1)

output = apm(s,a,'solve')
print(output)

z = apm_sol(s,a)

xp = [-1.0000000e+00, \
      -8.0000000e-01, \
      -5.0000000e-01, \
      -2.5000000e-01, \
       0.0000000e+00, \
       1.0000000e-01, \
       2.0000000e-01, \
       5.0000000e-01]

xm = np.linspace(-2,4,100)

plt.figure(1)

plt.plot(z['x'],z['y'],'r.-',label='cspline',linewidth=2)
plt.plot(xp,y(xp),'bo',label='data')
plt.plot(xm,y(xm),'k--',label='actual')
plt.xlim([-2,1])
plt.ylim([-0.1,1.1])
plt.text(-1.8,0.05,r'$\frac{1}{1+25 x^2}$')

plt.legend(loc='best')
plt.show()


